"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuntimeMappingsFromSort = exports.getMultiFieldsSort = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuntimeMappingsFromSort = (fields, sort) => {
  return sort.filter(([field]) => fields.includes(field)).reduce((acc, [field]) => {
    const type = 'keyword';
    return {
      ...acc,
      [field]: {
        type
      }
    };
  }, {});
};
exports.getRuntimeMappingsFromSort = getRuntimeMappingsFromSort;
const getMultiFieldsSort = sort => {
  return sort.map(([id, direction]) => {
    return {
      ...getSortField({
        field: id,
        direction
      })
    };
  });
};

/**
 * By default, ES will sort keyword fields in case-sensitive format, the
 * following fields are required to have a case-insensitive sorting.
 */
exports.getMultiFieldsSort = getMultiFieldsSort;
const fieldsRequiredSortingByPainlessScript = [_constants.ASSET_FIELDS.ENTITY_NAME]; // TODO TBD

/**
 * Generates Painless sorting if the given field is matched or returns default sorting
 * This painless script will sort the field in case-insensitive manner
 */
const getSortField = ({
  field,
  direction
}) => {
  if (fieldsRequiredSortingByPainlessScript.includes(field)) {
    return {
      _script: {
        type: 'string',
        order: direction,
        script: {
          source: `doc["${field}"].value.toLowerCase()`,
          lang: 'painless'
        }
      }
    };
  }
  return {
    [field]: direction
  };
};