"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRedux = require("react-redux");
var _constants = require("../../common/constants");
var _route_capture = require("../common/components/endpoint/route_capture");
var _kibana = require("../common/lib/kibana");
var _manage_spy_routes = require("../common/utils/route/manage_spy_routes");
var _ = require("./404");
var _home = require("./home");
var _alert_details_redirect = require("../detections/pages/alerts/alert_details_redirect");
var _cases = require("../cases");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/app/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PageRouterComponent = ({
  children,
  history
}) => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const CasesContext = cases.ui.getCasesContext();
  const userCasesPermissions = cases.helpers.canUseCases([_constants.APP_ID]);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    return () => {
      // When app is dismounted via a non-router method (ex. using Kibana's `services.application.navigateToApp()`)
      // ensure that one last `userChangedUrl` store action is dispatched, which will help trigger state reset logic
      dispatch({
        type: 'userChangedUrl',
        payload: {
          pathname: '',
          search: '',
          hash: ''
        }
      });
    };
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_manage_spy_routes.ManageRoutesSpy, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_route_capture.RouteCapture, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.ALERT_DETAILS_REDIRECT_PATH}/:alertId`,
    component: _alert_details_redirect.AlertDetailsRedirect,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [_constants.APP_ID],
    permissions: userCasesPermissions,
    features: _cases.CASES_FEATURES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_home.HomePage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 17
    }
  }, children))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_.NotFoundPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 15
    }
  }))))));
};
const PageRouter = exports.PageRouter = /*#__PURE__*/(0, _react.memo)(PageRouterComponent);