"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.set = set;
exports.setProp = setProp;
var _fp = _interopRequireDefault(require("lodash/fp"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Proxy for lodash fp `set` with better type inference. Overloaded to support both imperative and point free style.
 *
 * If an invalid path is passed, the type of the `value` parameter is `never` which should cause a type error.
 * Do **not** do an `as never` assertion to get around this, but instead make sure that the path is correct.
 *
 * Dynamic paths is supported if an array is passed as `path`.
 * If an array is passed as `path`, it needs to be `const`: `["foo", "bar"] as const`
 */

function set(...args) {
  if (args.length === 3) {
    const [obj, path, value] = args;
    return _fp.default.set(path)(value)(obj);
  }
  const [path, value] = args;
  return _fp.default.set(path)(value);
}
function setProp(...args) {
  if (args.length === 3) {
    const [obj, path, value] = args;
    return _fp.default.set(path, value)(obj);
  }
  const [path, value] = args;
  return obj => _fp.default.set(path, value)(obj);
}