"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplunkOriginalDashboardProperties = exports.SplunkOriginalDashboardExportProperties = exports.SplunkOriginalDashboardExport = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: SIEM Dashboard Migration components
 *   version: not applicable
 */

/**
 * Properties of the original dashboard
 */

const SplunkOriginalDashboardExportProperties = exports.SplunkOriginalDashboardExportProperties = _zod.z.object({
  /**
   * The unique identifier for the dashboard
   */
  id: _zod.z.string(),
  /**
   * The label of the dashboard
   */
  label: _zod.z.string().optional(),
  /**
   * The title of the dashboard
   */
  title: _zod.z.string(),
  /**
   * The description of the dashboard
   */
  description: _zod.z.string().optional(),
  /**
   * The EAI data of the dashboard, typically in XML format
   */
  'eai:data': _zod.z.string(),
  /**
   * The application associated with the EAI ACL
   */
  'eai:acl.app': _zod.z.string().optional(),
  /**
   * The sharing model of the EAI ACL (e.g., app, global)
   */
  'eai:acl.sharing': _zod.z.string().optional(),
  /**
   * The owner of the EAI ACL
   */
  'eai:acl.owner': _zod.z.string().optional(),
  /**
   * The last updated timestamp of the dashboard
   */
  updated: _zod.z.string().optional(),
  /**
   * The version of the dashboard
   */
  version: _zod.z.string().optional()
});

/**
 * Data Model for Splunk's original dashboard
 */

const SplunkOriginalDashboardExport = exports.SplunkOriginalDashboardExport = _zod.z.object({
  /**
   * The result object in Splunk file containing the dashboard's properties
   */
  result: SplunkOriginalDashboardExportProperties
});

/**
 * Properties of the original dashboard
 */

const SplunkOriginalDashboardProperties = exports.SplunkOriginalDashboardProperties = _zod.z.object({
  /**
   * The application associated with the EAI ACL
   */
  app: _zod.z.string().optional(),
  /**
   * The sharing model of the EAI ACL (e.g., app, global)
   */
  sharing: _zod.z.string().optional(),
  /**
   * The owner of the EAI ACL
   */
  owner: _zod.z.string().optional()
});