"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertsFieldMap8130 = void 0;
var _ = require("../8.4.0");
var _field_names = require("../field_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsFieldMap8130 = exports.alertsFieldMap8130 = {
  ..._.alertsFieldMap840,
  [_field_names.LEGACY_ALERT_HOST_CRITICALITY]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_field_names.LEGACY_ALERT_USER_CRITICALITY]: {
    type: 'keyword',
    array: false,
    required: false
  },
  /**
   * Stores the criticality level for the host, as determined by analysts, in relation to the alert.
   * The Criticality level is copied from the asset criticality index.
   */
  [_field_names.ALERT_HOST_CRITICALITY]: {
    type: 'keyword',
    array: false,
    required: false
  },
  /**
   * Stores the criticality level for the user, as determined by analysts, in relation to the alert.
   * The Criticality level is copied from the asset criticality index.
   */
  [_field_names.ALERT_USER_CRITICALITY]: {
    type: 'keyword',
    array: false,
    required: false
  }
};