"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PutTrustedDeviceUpdateRequestSchema = exports.PostTrustedDeviceCreateRequestSchema = exports.GetTrustedDevicesSummaryRequestSchema = exports.GetTrustedDevicesRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetTrustedDevicesRequestSchema = exports.GetTrustedDevicesRequestSchema = {
  query: _configSchema.schema.object({
    page: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 1,
      min: 1
    })),
    per_page: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 20,
      min: 1
    })),
    kuery: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};
const GetTrustedDevicesSummaryRequestSchema = exports.GetTrustedDevicesSummaryRequestSchema = {
  query: _configSchema.schema.object({
    kuery: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};
const ConditionEntryTypeSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('match'), _configSchema.schema.literal('wildcard')]);
const ConditionEntryOperatorSchema = _configSchema.schema.literal('included');
const TrustedDeviceEntrySchema = _configSchema.schema.object({
  field: _configSchema.schema.oneOf([_configSchema.schema.literal(_securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_ID), _configSchema.schema.literal(_securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_TYPE), _configSchema.schema.literal(_securitysolutionUtils.TrustedDeviceConditionEntryField.HOST), _configSchema.schema.literal(_securitysolutionUtils.TrustedDeviceConditionEntryField.MANUFACTURER), _configSchema.schema.literal(_securitysolutionUtils.TrustedDeviceConditionEntryField.MANUFACTURER_ID), _configSchema.schema.literal(_securitysolutionUtils.TrustedDeviceConditionEntryField.PRODUCT_ID), _configSchema.schema.literal(_securitysolutionUtils.TrustedDeviceConditionEntryField.PRODUCT_NAME), _configSchema.schema.literal(_securitysolutionUtils.TrustedDeviceConditionEntryField.USERNAME)]),
  type: ConditionEntryTypeSchema,
  operator: ConditionEntryOperatorSchema,
  value: _configSchema.schema.string({
    validate: field => field.length > 0 ? undefined : `invalidField.${field}`
  })
});
const getTrustedDeviceDuplicateFields = entries => {
  const fields = [];
  const seen = new Set();
  for (const entry of entries) {
    if (seen.has(entry.field)) {
      fields.push(entry.field);
    } else {
      seen.add(entry.field);
    }
  }
  return fields;
};
const entriesSchemaOptions = {
  minSize: 1,
  validate(entries) {
    return getTrustedDeviceDuplicateFields(entries).map(field => `duplicatedEntry.${field}`).join(', ') || undefined;
  }
};
const EntriesSchema = _configSchema.schema.arrayOf(TrustedDeviceEntrySchema, entriesSchemaOptions);
const getTrustedDeviceForOsScheme = () => _configSchema.schema.object({
  name: _configSchema.schema.string({
    minLength: 1,
    maxLength: 256
  }),
  description: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 0,
    maxLength: 256,
    defaultValue: ''
  })),
  os: _configSchema.schema.oneOf([_configSchema.schema.literal(_securitysolutionUtils.OperatingSystem.WINDOWS), _configSchema.schema.literal(_securitysolutionUtils.OperatingSystem.MAC)
  // Note: Linux support will be added in the future
  ]),
  effectScope: _configSchema.schema.oneOf([_configSchema.schema.object({
    type: _configSchema.schema.literal('global')
  }), _configSchema.schema.object({
    type: _configSchema.schema.literal('policy'),
    policies: _configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }))
  })]),
  entries: EntriesSchema,
  version: _configSchema.schema.maybe(_configSchema.schema.string())
});
const PostTrustedDeviceCreateRequestSchema = exports.PostTrustedDeviceCreateRequestSchema = {
  body: getTrustedDeviceForOsScheme()
};
const PutTrustedDeviceUpdateRequestSchema = exports.PutTrustedDeviceUpdateRequestSchema = {
  params: _configSchema.schema.object({
    id: _configSchema.schema.string()
  }),
  body: getTrustedDeviceForOsScheme()
};