"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRuleCustomized = exports.addEcsToRequiredFields = void 0;
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
  Computes the boolean "ecs" property value for each required field based on the ECS field map.
  "ecs" property indicates whether the required field is an ECS field or not.
*/
const addEcsToRequiredFields = requiredFields => (requiredFields !== null && requiredFields !== void 0 ? requiredFields : []).map(requiredFieldWithoutEcs => {
  var _ecsFieldMap$required;
  const isEcsField = Boolean(((_ecsFieldMap$required = _alertsAsDataUtils.ecsFieldMap[requiredFieldWithoutEcs.name]) === null || _ecsFieldMap$required === void 0 ? void 0 : _ecsFieldMap$required.type) === requiredFieldWithoutEcs.type);
  return {
    ...requiredFieldWithoutEcs,
    ecs: isEcsField
  };
});
exports.addEcsToRequiredFields = addEcsToRequiredFields;
const isRuleCustomized = rule => rule.rule_source.type === 'external' && rule.rule_source.is_customized === true;
exports.isRuleCustomized = isRuleCustomized;