"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PendingActionsSchema = exports.PendingActionDataType = exports.EndpointGetActionsStatusResponse = exports.EndpointGetActionsStatusRequestQuery = exports.ActionStatusSuccessResponse = void 0;
var _zod = require("@kbn/zod");
var _common = require("../../model/schema/common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Get Action status schema
 *   version: 2023-10-31
 */

const PendingActionDataType = exports.PendingActionDataType = _zod.z.number().int();
const PendingActionsSchema = exports.PendingActionsSchema = _zod.z.union([_zod.z.object({
  isolate: PendingActionDataType.optional(),
  unisolate: PendingActionDataType.optional(),
  'kill-process': PendingActionDataType.optional(),
  'suspend-process': PendingActionDataType.optional(),
  'running-processes': PendingActionDataType.optional(),
  'get-file': PendingActionDataType.optional(),
  execute: PendingActionDataType.optional(),
  upload: PendingActionDataType.optional(),
  scan: PendingActionDataType.optional()
}), _zod.z.object({}).catchall(_zod.z.unknown())]);
const ActionStatusSuccessResponse = exports.ActionStatusSuccessResponse = _zod.z.object({
  body: _zod.z.object({
    data: _zod.z.object({
      agent_id: _common.AgentId,
      pending_actions: PendingActionsSchema
    })
  })
});
const EndpointGetActionsStatusRequestQuery = exports.EndpointGetActionsStatusRequestQuery = _zod.z.object({
  query: _zod.z.object({
    agent_ids: _common.AgentIds.optional()
  })
});
const EndpointGetActionsStatusResponse = exports.EndpointGetActionsStatusResponse = ActionStatusSuccessResponse;