"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregatedPrebuiltRuleError = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../../model/rule_schema/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AggregatedPrebuiltRuleError = exports.AggregatedPrebuiltRuleError = _zod.z.object({
  message: _zod.z.string(),
  status_code: _zod.z.number().optional(),
  rules: _zod.z.array(_zod.z.object({
    rule_id: _common_attributes.RuleSignatureId,
    name: _common_attributes.RuleName.optional()
  }))
});