"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssistantSubFeaturesMap = exports.getAssistantBaseKibanaSubFeatureIds = exports.AssistantSubFeatureId = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateAnonymizationSubFeature = {
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.assistant.updateAnonymizationSubFeatureName', {
    defaultMessage: 'Field Selection and Anonymization'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.assistant.description', {
    defaultMessage: 'Change the default fields that are allowed to be used by the AI Assistant and Attack discovery. Anonymize any of the content for the selected fields.'
  }),
  privilegeGroups: [{
    groupType: 'independent',
    privileges: [{
      api: [`${_constants.APP_ID}-updateAIAssistantAnonymization`],
      id: 'update_anonymization',
      name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.assistant.updateAnonymizationSubFeatureDetails', {
        defaultMessage: 'Allow changes'
      }),
      includeIn: 'all',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['updateAIAssistantAnonymization']
    }]
  }]
};
const manageGlobalKnowledgeBaseSubFeature = {
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.assistant.manageGlobalKnowledgeBaseSubFeatureName', {
    defaultMessage: 'Knowledge Base'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.assistant.manageGlobalKnowledgeBaseSubFeatureDescription', {
    defaultMessage: 'Make changes to any space level (global) custom knowledge base entries. This will also allow users to modify global entries created by other users.'
  }),
  privilegeGroups: [{
    groupType: 'independent',
    privileges: [{
      api: [`${_constants.APP_ID}-manageGlobalKnowledgeBaseAIAssistant`],
      id: 'manage_global_knowledge_base',
      name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.assistant.manageGlobalKnowledgeBaseSubFeatureDetails', {
        defaultMessage: 'Allow Changes to Global Entries'
      }),
      includeIn: 'all',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['manageGlobalKnowledgeBaseAIAssistant']
    }]
  }]
};
let AssistantSubFeatureId = exports.AssistantSubFeatureId = /*#__PURE__*/function (AssistantSubFeatureId) {
  AssistantSubFeatureId["updateAnonymization"] = "updateAnonymizationSubFeature";
  AssistantSubFeatureId["manageGlobalKnowledgeBase"] = "manageGlobalKnowledgeBaseSubFeature";
  return AssistantSubFeatureId;
}({});
/**
 * Sub-features that will always be available for Security Assistant
 * regardless of the product type.
 */
const getAssistantBaseKibanaSubFeatureIds = () => [];

/**
 * Defines all the Security Assistant subFeatures available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getAssistantBaseKibanaSubFeatureIds = getAssistantBaseKibanaSubFeatureIds;
const getAssistantSubFeaturesMap = experimentalFeatures => {
  const assistantSubFeaturesList = [[AssistantSubFeatureId.updateAnonymization, updateAnonymizationSubFeature], [AssistantSubFeatureId.manageGlobalKnowledgeBase, manageGlobalKnowledgeBaseSubFeature]];

  // Use the following code to add feature based on feature flag
  // if (experimentalFeatures.featureFlagName) {
  //   assistantSubFeaturesList.push([AssistantSubFeatureId.featureId, featureSubFeature]);
  // }

  const assistantSubFeaturesMap = new Map(assistantSubFeaturesList);
  return Object.freeze(assistantSubFeaturesMap);
};
exports.getAssistantSubFeaturesMap = getAssistantSubFeaturesMap;