"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionExpired = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNextParameter = () => {
  const {
    location
  } = window;
  const next = encodeURIComponent(`${location.pathname}${location.search}${location.hash}`);
  return `&${_constants.NEXT_URL_QUERY_STRING_PARAMETER}=${next}`;
};
const getProviderParameter = tenant => {
  const key = `${tenant}/session_provider`;
  const providerName = sessionStorage.getItem(key);
  return providerName ? `&${_constants.LOGOUT_PROVIDER_QUERY_STRING_PARAMETER}=${encodeURIComponent(providerName)}` : '';
};
class SessionExpired {
  constructor(application, logoutUrl, tenant) {
    this.application = application;
    this.logoutUrl = logoutUrl;
    this.tenant = tenant;
  }
  logout(reason) {
    const next = getNextParameter();
    const provider = getProviderParameter(this.tenant);
    this.application.navigateToUrl(`${this.logoutUrl}?${_constants.LOGOUT_REASON_QUERY_STRING_PARAMETER}=${reason}${next}${provider}`, {
      forceRedirect: true,
      skipAppLeave: true
    });
  }
}
exports.SessionExpired = SessionExpired;