"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegesAPIClient = void 0;
var _securityPluginTypesPublic = require("@kbn/security-plugin-types-public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PrivilegesAPIClient extends _securityPluginTypesPublic.PrivilegesAPIClientPublicContract {
  constructor(http) {
    super();
    this.http = http;
  }
  async getAll({
    includeActions,
    respectLicenseLevel = true
  }) {
    return await this.http.get('/api/security/privileges', {
      query: {
        includeActions,
        respectLicenseLevel
      }
    });
  }
  async getBuiltIn() {
    return await this.http.get('/internal/security/esPrivileges/builtin');
  }
}
exports.PrivilegesAPIClient = PrivilegesAPIClient;