"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesAPIClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IndicesAPIClient {
  constructor(http) {
    (0, _defineProperty2.default)(this, "fieldCache", new Map());
    this.http = http;
  }
  async getFields(pattern) {
    var _this$fieldCache$get;
    if (pattern && !this.fieldCache.has(pattern)) {
      const fields = await this.http.get(`/internal/security/fields/${encodeURIComponent(pattern)}`);
      if (Array.isArray(fields) && fields.length > 0) {
        this.fieldCache.set(pattern, fields);
      }
    }
    return (_this$fieldCache$get = this.fieldCache.get(pattern)) !== null && _this$fieldCache$get !== void 0 ? _this$fieldCache$get : [];
  }
}
exports.IndicesAPIClient = IndicesAPIClient;