"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldRule = void 0;
var _i18n = require("@kbn/i18n");
var _rule = require("./rule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** The allowed types for field rule values */

/**
 * Represents a single field rule.
 * Ex: "username = 'foo'"
 */
class FieldRule extends _rule.Rule {
  constructor(field, value) {
    super();
    this.field = field;
    this.value = value;
  }

  /** {@see Rule.getDisplayTitle} */
  getDisplayTitle() {
    return _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRule.displayTitle', {
      defaultMessage: 'The following is true'
    });
  }

  /** {@see Rule.clone} */
  clone() {
    return new FieldRule(this.field, Array.isArray(this.value) ? [...this.value] : this.value);
  }

  /** {@see Rule.toRaw} */
  toRaw() {
    return {
      field: {
        [this.field]: Array.isArray(this.value) ? [...this.value] : this.value
      }
    };
  }
}
exports.FieldRule = FieldRule;