"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logoutApp = void 0;
var _i18n = require("@kbn/i18n");
var _analytics = require("../../analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logoutApp = exports.logoutApp = Object.freeze({
  id: 'security_logout',
  create({
    application,
    http
  }) {
    http.anonymousPaths.register('/logout');
    application.register({
      id: this.id,
      title: _i18n.i18n.translate('xpack.security.logoutAppTitle', {
        defaultMessage: 'Logout'
      }),
      chromeless: true,
      appRoute: '/logout',
      async mount() {
        window.sessionStorage.clear();
        window.localStorage.removeItem(_analytics.AnalyticsService.AuthTypeInfoStorageKey);

        // Redirect user to the server logout endpoint to complete logout.
        window.location.href = http.basePath.prepend(`/api/security/logout${window.location.search}`);
        return () => {};
      }
    });
  }
});