"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateRestApiKeySchema = exports.updateCrossClusterApiKeySchema = exports.restApiKeySchema = exports.getUpdateRestApiKeyWithKibanaPrivilegesSchema = exports.getRestApiKeyWithKibanaPrivilegesSchema = exports.crossClusterApiKeySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _authorization = require("../../authorization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const restApiKeySchema = exports.restApiKeySchema = _configSchema.schema.object({
  type: _configSchema.schema.maybe(_configSchema.schema.literal('rest')),
  name: _configSchema.schema.string(),
  expiration: _configSchema.schema.maybe(_configSchema.schema.string()),
  role_descriptors: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({}, {
    unknowns: 'allow'
  }), {
    defaultValue: {}
  }),
  metadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))
});
const getRestApiKeyWithKibanaPrivilegesSchema = getBasePrivilegeNames => _configSchema.schema.object({
  type: _configSchema.schema.maybe(_configSchema.schema.literal('rest')),
  name: _configSchema.schema.string(),
  expiration: _configSchema.schema.maybe(_configSchema.schema.string()),
  metadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  })),
  kibana_role_descriptors: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    elasticsearch: _authorization.elasticsearchRoleSchema.extends({}, {
      unknowns: 'allow'
    }),
    kibana: (0, _authorization.getKibanaRoleSchema)(getBasePrivilegeNames)
  }))
});
exports.getRestApiKeyWithKibanaPrivilegesSchema = getRestApiKeyWithKibanaPrivilegesSchema;
const crossClusterApiKeySchema = exports.crossClusterApiKeySchema = _configSchema.schema.object({
  type: _configSchema.schema.literal('cross_cluster'),
  name: _configSchema.schema.string(),
  expiration: _configSchema.schema.maybe(_configSchema.schema.string()),
  metadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  })),
  access: _configSchema.schema.object({
    search: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      names: _configSchema.schema.arrayOf(_configSchema.schema.string()),
      query: _configSchema.schema.maybe(_configSchema.schema.any()),
      field_security: _configSchema.schema.maybe(_configSchema.schema.any()),
      allow_restricted_indices: _configSchema.schema.maybe(_configSchema.schema.boolean())
    }))),
    replication: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      names: _configSchema.schema.arrayOf(_configSchema.schema.string())
    })))
  }, {
    unknowns: 'allow'
  })
});
const updateRestApiKeySchema = exports.updateRestApiKeySchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.maybe(_configSchema.schema.literal('rest')),
  expiration: _configSchema.schema.maybe(_configSchema.schema.string()),
  role_descriptors: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({}, {
    unknowns: 'allow'
  }), {
    defaultValue: {}
  }),
  metadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))
});
const updateCrossClusterApiKeySchema = exports.updateCrossClusterApiKeySchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.literal('cross_cluster'),
  expiration: _configSchema.schema.maybe(_configSchema.schema.string()),
  metadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  })),
  access: _configSchema.schema.object({
    search: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      names: _configSchema.schema.arrayOf(_configSchema.schema.string()),
      query: _configSchema.schema.maybe(_configSchema.schema.any()),
      field_security: _configSchema.schema.maybe(_configSchema.schema.any()),
      allow_restricted_indices: _configSchema.schema.maybe(_configSchema.schema.boolean())
    }))),
    replication: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      names: _configSchema.schema.arrayOf(_configSchema.schema.string())
    })))
  }, {
    unknowns: 'allow'
  })
});
const getUpdateRestApiKeyWithKibanaPrivilegesSchema = getBasePrivilegeNames => _configSchema.schema.object({
  type: _configSchema.schema.maybe(_configSchema.schema.literal('rest')),
  expiration: _configSchema.schema.maybe(_configSchema.schema.string()),
  metadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  })),
  id: _configSchema.schema.string(),
  kibana_role_descriptors: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    elasticsearch: _authorization.elasticsearchRoleSchema.extends({}, {
      unknowns: 'allow'
    }),
    kibana: (0, _authorization.getKibanaRoleSchema)(getBasePrivilegeNames)
  }))
});
exports.getUpdateRestApiKeyWithKibanaPrivilegesSchema = getUpdateRestApiKeyWithKibanaPrivilegesSchema;