"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynonymsSetDetail = void 0;
var _reactRouterDom = require("react-router-dom");
var _react = _interopRequireWildcard(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18n = require("@kbn/i18n");
var _api_routes = require("../../../common/api_routes");
var _use_kibana = require("../../hooks/use_kibana");
var _use_synonyms_breadcrumbs = require("../../hooks/use_synonyms_breadcrumbs");
var _synonyms_set_rule_table = require("./synonyms_set_rule_table");
var _connect_to_api_button = require("../connect_to_api/connect_to_api_button");
var _connect_to_api_flyout = require("../connect_to_api/connect_to_api_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_synonyms/public/components/synonyms_set_detail/synonyms_set_detail.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SynonymsSetDetail = () => {
  const {
    synonymsSetId = ''
  } = (0, _reactRouterDom.useParams)();
  const {
    services: {
      console: consolePlugin,
      history,
      searchNavigation,
      http,
      application
    }
  } = (0, _use_kibana.useKibana)();
  (0, _use_synonyms_breadcrumbs.useSynonymsBreadcrumbs)(synonymsSetId);
  const embeddableConsole = (0, _react.useMemo)(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 47
    }
  }) : null, [consolePlugin]);
  const [isApiConnectModalVisible, setIsApiConnectModalVisible] = _react.default.useState(false);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: false,
    grow: false,
    "data-test-subj": "searchSynonymsSetDetailPage",
    solutionNav: searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.useClassicNavigation(history),
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: synonymsSetId,
    restrictWidth: true,
    color: "primary",
    breadcrumbs: [{
      text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.searchSynonyms.viewAll', {
        defaultMessage: 'View all'
      })),
      color: 'primary',
      'aria-current': false,
      onClick: e => {
        e.preventDefault();
        application.navigateToUrl(http.basePath.prepend(_api_routes.PLUGIN_ROUTE_ROOT));
      }
    }],
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_connect_to_api_button.ConnectToApiButton, {
      onClick: () => {
        setIsApiConnectModalVisible(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    restrictWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, synonymsSetId && /*#__PURE__*/_react.default.createElement(_synonyms_set_rule_table.SynonymsSetRuleTable, {
    synonymsSetId: synonymsSetId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 27
    }
  }), isApiConnectModalVisible && /*#__PURE__*/_react.default.createElement(_connect_to_api_flyout.ConnectToApiFlyout, {
    rulesetId: synonymsSetId,
    onClose: () => {
      setIsApiConnectModalVisible(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  })), embeddableConsole);
};
exports.SynonymsSetDetail = SynonymsSetDetail;