"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchIndexNames = void 0;
var _reactQuery = require("@tanstack/react-query");
var _api_routes = require("../../common/api_routes");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchIndexNames = searchQuery => {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['fetchIndexNames', searchQuery],
    queryFn: async () => {
      const response = await http.get(_api_routes.APIRoutes.FETCH_INDICES, {
        ...(searchQuery.trim() === '' ? {} : {
          query: {
            searchQuery
          }
        })
      });
      return response;
    },
    refetchOnWindowFocus: false,
    retry: false
  });
};
exports.useFetchIndexNames = useFetchIndexNames;