"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValueForSelectedField = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getValueForSelectedField = (hit, path) => {
  if (!hit) {
    return '';
  }

  // for semantic_text matches
  if (hit.highlight && hit.highlight[path]) {
    return hit.highlight[path].flat().join('\n --- \n');
  }
  return (0, _lodash.has)(hit._source, `${path}.text`) ? (0, _lodash.get)(hit._source, `${path}.text`, '') : (0, _lodash.get)(hit._source, path, '');
};
exports.getValueForSelectedField = getValueForSelectedField;