"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.playgroundAttributesSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const playgroundAttributesSchema = exports.playgroundAttributesSchema = _configSchema.schema.object({
  name: _configSchema.schema.string({
    minLength: 1,
    maxLength: 50
  }),
  // Common fields
  indices: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1
  }),
  queryFields: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1
  })),
  elasticsearchQueryJSON: _configSchema.schema.string(),
  userElasticsearchQueryJSON: _configSchema.schema.maybe(_configSchema.schema.string()),
  // Chat fields
  prompt: _configSchema.schema.maybe(_configSchema.schema.string()),
  citations: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  context: _configSchema.schema.maybe(_configSchema.schema.object({
    sourceFields: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      minSize: 1
    })),
    docSize: _configSchema.schema.number({
      defaultValue: 3,
      min: 1
    })
  })),
  summarizationModel: _configSchema.schema.maybe(_configSchema.schema.object({
    connectorId: _configSchema.schema.string(),
    modelId: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
});