"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchPreview = exports.fetchSearchResults = exports.DEFAULT_SEARCH_PREVIEW_DATA = void 0;
var _reactQuery = require("@tanstack/react-query");
var _reactHookForm = require("react-hook-form");
var _types = require("../types");
var _use_kibana = require("./use_kibana");
var _common = require("../../common");
var _user_query = require("../utils/user_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SEARCH_PREVIEW_DATA = exports.DEFAULT_SEARCH_PREVIEW_DATA = {
  executionTime: 0,
  results: [],
  pagination: _common.DEFAULT_PAGINATION
};
const fetchSearchResults = async ({
  query,
  indices,
  elasticsearchQuery,
  pagination: paginationParam = _common.DEFAULT_PAGINATION,
  http
}) => {
  return http.post(_types.APIRoutes.POST_SEARCH_QUERY, {
    body: JSON.stringify({
      search_query: query,
      elasticsearch_query: JSON.stringify(elasticsearchQuery),
      indices,
      size: paginationParam.size,
      from: paginationParam.from
    })
  });
};
exports.fetchSearchResults = fetchSearchResults;
const useSearchPreview = ({
  query,
  pagination
}) => {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const {
    getValues,
    formState: {
      errors: formErrors
    }
  } = (0, _reactHookForm.useFormContext)();
  const indices = getValues(_types.PlaygroundFormFields.indices);
  const elasticsearchQuery = getValues(_types.PlaygroundFormFields.elasticsearchQuery);
  const queryFn = () => {
    const formData = getValues();
    const elasticsearchQueryBody = (0, _user_query.elasticsearchQueryObject)(formData[_types.PlaygroundFormFields.elasticsearchQuery], formData[_types.PlaygroundFormFields.userElasticsearchQuery], formErrors[_types.PlaygroundFormFields.userElasticsearchQuery]);
    return fetchSearchResults({
      query,
      pagination,
      http,
      indices: formData[_types.PlaygroundFormFields.indices],
      elasticsearchQuery: elasticsearchQueryBody
    });
  };
  const {
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: [_common.SearchPlaygroundQueryKeys.SearchPreviewResults, query, indices, elasticsearchQuery, pagination],
    queryFn,
    initialData: DEFAULT_SEARCH_PREVIEW_DATA,
    enabled: !!query,
    refetchOnWindowFocus: false,
    refetchOnReconnect: false,
    refetchOnMount: false
  });
  return {
    executionTime: data.executionTime,
    pagination: data.pagination,
    results: data.results
  };
};
exports.useSearchPreview = useSearchPreview;