"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePlaygroundBreadcrumbs = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePlaygroundBreadcrumbs = playgroundName => {
  var _cloud$isServerlessEn;
  const {
    cloud,
    http,
    searchNavigation
  } = (0, _use_kibana.useKibana)().services;
  const isServerless = (_cloud$isServerlessEn = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) !== null && _cloud$isServerlessEn !== void 0 ? _cloud$isServerlessEn : false;
  (0, _react.useEffect)(() => {
    searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.setSearchBreadCrumbs([...(isServerless ? [] // Serverless is setting Build breadcrumb automatically
    : [{
      text: _i18n.i18n.translate('xpack.searchPlayground.breadcrumbs.build', {
        defaultMessage: 'Build'
      })
    }]), {
      text: _i18n.i18n.translate('xpack.searchPlayground.breadcrumbs.playground', {
        defaultMessage: 'Playground'
      }),
      href: playgroundName !== undefined ? http.basePath.prepend(_common.PLUGIN_PATH) : undefined
    }, ...(playgroundName !== undefined ? [{
      text: playgroundName
    }] : [])]);
    return () => {
      // Clear breadcrumbs on unmount;
      searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.clearBreadcrumbs();
    };
  }, [http, searchNavigation, isServerless, playgroundName]);
};
exports.usePlaygroundBreadcrumbs = usePlaygroundBreadcrumbs;