"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useManagementLink = void 0;
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useManagementLink = connectorId => {
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibana)();
  const managementLocator = (0, _react.useMemo)(() => share.url.locators.get('MANAGEMENT_APP_LOCATOR'), [share.url.locators]);
  const [managementLink, setManagementLink] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    const getLink = async () => {
      const link = await (managementLocator === null || managementLocator === void 0 ? void 0 : managementLocator.getUrl({
        sectionId: 'insightsAndAlerting',
        appId: `triggersActionsConnectors/connectors/${connectorId}`
      }));
      setManagementLink(link || '');
    };
    getLink();
  }, [managementLocator, connectorId]);
  return managementLink;
};
exports.useManagementLink = useManagementLink;