"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageRole = exports.LLMs = exports.APIRoutes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let MessageRole = exports.MessageRole = /*#__PURE__*/function (MessageRole) {
  MessageRole["user"] = "human";
  MessageRole["assistant"] = "assistant";
  MessageRole["system"] = "system";
  return MessageRole;
}({});
const BASE_API_PATH = '/internal/search_playground';
let APIRoutes = exports.APIRoutes = /*#__PURE__*/function (APIRoutes) {
  APIRoutes["BASE_API"] = "/internal/search_playground";
  APIRoutes["POST_API_KEY"] = "/internal/search_playground/api_key";
  APIRoutes["POST_CHAT_MESSAGE"] = "/internal/search_playground/chat";
  APIRoutes["POST_QUERY_SOURCE_FIELDS"] = "/internal/search_playground/query_source_fields";
  APIRoutes["GET_INDICES"] = "/internal/search_playground/indices";
  APIRoutes["POST_SEARCH_QUERY"] = "/internal/search_playground/search";
  APIRoutes["GET_INDEX_MAPPINGS"] = "/internal/search_playground/mappings";
  APIRoutes["POST_QUERY_TEST"] = "/internal/search_playground/query_test";
  APIRoutes["PUT_PLAYGROUND_CREATE"] = "/internal/search_playground/playgrounds";
  APIRoutes["PUT_PLAYGROUND_UPDATE"] = "/internal/search_playground/playgrounds/{id}";
  APIRoutes["GET_PLAYGROUND"] = "/internal/search_playground/playgrounds/{id}";
  APIRoutes["GET_PLAYGROUNDS"] = "/internal/search_playground/playgrounds";
  APIRoutes["DELETE_PLAYGROUND"] = "/internal/search_playground/playgrounds/{id}";
  return APIRoutes;
}({});
let LLMs = exports.LLMs = /*#__PURE__*/function (LLMs) {
  LLMs["openai"] = "openai";
  LLMs["openai_azure"] = "openai_azure";
  LLMs["openai_other"] = "openai_other";
  LLMs["bedrock"] = "bedrock";
  LLMs["gemini"] = "gemini";
  LLMs["inference"] = "inference";
  return LLMs;
}({});