"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _configSchema = require("@kbn/config-schema");
var _fetch_inference_endpoints = require("./lib/fetch_inference_endpoints");
var _types = require("./types");
var _error_handler = require("./utils/error_handler");
var _delete_inference_endpoint = require("./lib/delete_inference_endpoint");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineRoutes({
  logger,
  router
}) {
  router.get({
    path: _types.APIRoutes.GET_INFERENCE_ENDPOINTS,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: {}
  }, (0, _error_handler.errorHandler)(logger)(async (context, request, response) => {
    const {
      client: {
        asCurrentUser
      }
    } = (await context.core).elasticsearch;
    const {
      inferenceEndpoints
    } = await (0, _fetch_inference_endpoints.fetchInferenceEndpoints)(asCurrentUser);
    return response.ok({
      body: {
        inference_endpoints: inferenceEndpoints
      },
      headers: {
        'content-type': 'application/json'
      }
    });
  }));
  router.delete({
    path: _types.APIRoutes.INFERENCE_ENDPOINT,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: {
      params: _configSchema.schema.object({
        type: _configSchema.schema.string(),
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        scanUsage: _configSchema.schema.maybe(_configSchema.schema.boolean())
      })
    }
  }, (0, _error_handler.errorHandler)(logger)(async (context, request, response) => {
    const {
      client: {
        asCurrentUser
      }
    } = (await context.core).elasticsearch;
    const {
      type,
      id
    } = request.params;
    const {
      scanUsage
    } = request.query;
    const result = await (0, _delete_inference_endpoint.deleteInferenceEndpoint)(asCurrentUser, type, id, scanUsage !== null && scanUsage !== void 0 ? scanUsage : false);
    return response.ok({
      body: result
    });
  }));
}