"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScanUsage = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useScanUsage = ({
  type,
  id
}) => {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['inference-endpoint-scan-usage'],
    queryFn: () => services.http.delete(`/internal/inference_endpoint/endpoints/${type}/${id}`, {
      query: {
        scanUsage: true
      }
    })
  });
};
exports.useScanUsage = useScanUsage;