"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInferenceEndpointsBreadcrumbs = void 0;
var _react = require("react");
var i18n = _interopRequireWildcard(require("../../common/translations"));
var _use_kibana = require("./use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInferenceEndpointsBreadcrumbs = () => {
  const {
    searchNavigation
  } = (0, _use_kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.setSearchBreadCrumbs([{
      text: i18n.BREADCRUMB_RELEVANCE
    }, {
      text: i18n.BREADCRUMB_INFERENCE_ENDPOINTS
    }], {
      forClassicChromeStyle: true
    });
    return () => {
      // Clear breadcrumbs on unmount;
      searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.clearBreadcrumbs();
    };
  }, [searchNavigation]);
};
exports.useInferenceEndpointsBreadcrumbs = useInferenceEndpointsBreadcrumbs;