"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVERLESS_INDEX_MANAGEMENT_URL = exports.PIPELINE_URL = exports.DEFAULT_TABLE_LIMIT = exports.DEFAULT_TABLE_ACTIVE_PAGE = exports.DEFAULT_QUERY_PARAMS = exports.DEFAULT_INFERENCE_ENDPOINTS_TABLE_STATE = exports.DEFAULT_FILTER_OPTIONS = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TABLE_ACTIVE_PAGE = exports.DEFAULT_TABLE_ACTIVE_PAGE = 1;
const DEFAULT_TABLE_LIMIT = exports.DEFAULT_TABLE_LIMIT = 25;
const DEFAULT_QUERY_PARAMS = exports.DEFAULT_QUERY_PARAMS = {
  page: DEFAULT_TABLE_ACTIVE_PAGE,
  perPage: DEFAULT_TABLE_LIMIT,
  sortField: _types.SortFieldInferenceEndpoint.inference_id,
  sortOrder: _types.SortOrder.asc
};
const DEFAULT_FILTER_OPTIONS = exports.DEFAULT_FILTER_OPTIONS = {
  provider: [],
  type: []
};
const DEFAULT_INFERENCE_ENDPOINTS_TABLE_STATE = exports.DEFAULT_INFERENCE_ENDPOINTS_TABLE_STATE = {
  filterOptions: DEFAULT_FILTER_OPTIONS,
  queryParams: DEFAULT_QUERY_PARAMS
};
const PIPELINE_URL = exports.PIPELINE_URL = 'ingest/ingest_pipelines';
const SERVERLESS_INDEX_MANAGEMENT_URL = exports.SERVERLESS_INDEX_MANAGEMENT_URL = 'index_details';