"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerOnboardingRoutes = registerOnboardingRoutes;
var _server = require("@kbn/cloud-plugin/server");
var _routes = require("../../common/routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerOnboardingRoutes(router, logger) {
  router.get({
    path: _routes.GET_ONBOARDING_TOKEN_ROUTE,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: {},
    options: {
      access: 'internal'
    }
  }, async (context, _request, response) => {
    const core = await context.core;
    const savedObjectsClient = core.savedObjects.getClient({
      includedHiddenTypes: ['cloud']
    });
    const token = await (0, _server.getOnboardingToken)(savedObjectsClient);
    const body = {
      token
    };
    return response.ok({
      body,
      headers: {
        'content-type': 'application/json'
      }
    });
  });
}