"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchCodeExamples = void 0;
var _react = require("react");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
var _searchQueries = require("@kbn/search-queries");
var _use_elasticsearch_url = require("./use_elasticsearch_url");
var _use_kibana = require("./use_kibana");
var _code_examples = require("../code_examples");
var _search = require("../code_examples/search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_QUERY_STRING = 'REPLACE WITH YOUR QUERY';
const DEFAULT_QUERY_OBJECT = {
  retriever: {
    standard: {
      query: {
        query_string: {
          query: '*'
        }
      }
    }
  }
};
const useSearchCodeExamples = (indexName, mappings) => {
  const elasticsearchURL = (0, _use_elasticsearch_url.useElasticsearchUrl)();
  const {
    apiKey
  } = (0, _searchApiKeysComponents.useSearchApiKey)();
  const {
    cloud
  } = (0, _use_kibana.useKibana)().services;
  return (0, _react.useMemo)(() => {
    var _cloud$isServerlessEn;
    let queryObject = DEFAULT_QUERY_OBJECT;
    if (mappings) {
      try {
        const fields = (0, _searchQueries.buildFieldDescriptorForIndex)(indexName, mappings);
        queryObject = (0, _searchQueries.generateSearchQuery)((0, _searchQueries.getDefaultQueryFields)(fields), {}, fields, {
          rrf: true,
          queryString: DEFAULT_QUERY_STRING
        });
      } catch {
        // Ignore Errors here and fallback to default query object
      }
    }
    const codeParams = {
      elasticsearchURL,
      apiKey: apiKey !== null && apiKey !== void 0 ? apiKey : undefined,
      indexName,
      queryObject,
      isServerless: (_cloud$isServerlessEn = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) !== null && _cloud$isServerlessEn !== void 0 ? _cloud$isServerlessEn : false
    };
    const options = Object.entries(_code_examples.Languages).map(([key, language]) => ({
      language,
      code: _search.SearchCodeExample[key].searchCommand(codeParams)
    }));
    return {
      options,
      console: _search.SearchCodeExample.sense.searchCommand(codeParams)
    };
  }, [indexName, mappings, elasticsearchURL, apiKey, cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled]);
};
exports.useSearchCodeExamples = useSearchCodeExamples;