"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConnectorServiceType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const updateConnectorServiceType = async (client, connectorId, serviceType) => {
  // First clear connector configuration
  await client.transport.request({
    method: 'PUT',
    path: `/_connector/${connectorId}/_configuration`,
    body: {
      configuration: {}
    }
  });
  // Then update service type, on startup connector framework
  // will populate missing config fields
  return await client.transport.request({
    method: 'PUT',
    path: `/_connector/${connectorId}/_service_type`,
    body: {
      service_type: serviceType
    }
  });
};
exports.updateConnectorServiceType = updateConnectorServiceType;