"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConnectorIndexName = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const updateConnectorIndexName = async (client, connectorId, indexName) => {
  return await client.transport.request({
    method: 'PUT',
    path: `/_connector/${connectorId}/_index_name`,
    body: {
      index_name: indexName
    }
  });
};
exports.updateConnectorIndexName = updateConnectorIndexName;