"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CronDaily = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/cron_editor/cron_daily.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CronDaily = ({
  disabled,
  minute,
  minuteOptions,
  hour,
  hourOptions,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "searchConnectors.cronEditor.cronDaily.fieldTimeLabel",
    defaultMessage: "Time",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }),
  fullWidth: true,
  "data-test-subj": "cronFrequencyConfiguration",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  disabled: disabled,
  options: hourOptions,
  value: hour,
  "aria-label": _i18n.i18n.translate('searchConnectors.cronEditor.cronDaily.hourSelectLabel', {
    defaultMessage: 'Hour'
  }),
  onChange: e => onChange({
    hour: e.target.value
  }),
  fullWidth: true,
  prepend: _i18n.i18n.translate('searchConnectors.cronEditor.cronDaily.fieldHour.textAtLabel', {
    defaultMessage: 'At'
  }),
  "data-test-subj": "cronFrequencyDailyHourSelect",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  disabled: disabled,
  options: minuteOptions,
  value: minute,
  "aria-label": _i18n.i18n.translate('searchConnectors.cronEditor.cronDaily.minuteSelectLabel', {
    defaultMessage: 'Minute'
  }),
  onChange: e => onChange({
    minute: e.target.value
  }),
  fullWidth: true,
  prepend: ":",
  "data-test-subj": "cronFrequencyDailyMinuteSelect",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 11
  }
})))));
exports.CronDaily = CronDaily;