"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigurationFormItems = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("../..");
var _connector_configuration_field = require("./connector_configuration_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/configuration/connector_configuration_form_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ConnectorConfigurationFormItems = ({
  isLoading,
  items,
  hasDocumentLevelSecurityEnabled,
  setConfigEntry
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, items.map(configEntry => {
    const {
      default_value: defaultValue,
      depends_on: dependencies,
      key,
      display,
      isValid,
      label,
      sensitive,
      tooltip,
      validationErrors
    } = configEntry;
    if (key === 'use_document_level_security' && !hasDocumentLevelSecurityEnabled) {
      return null;
    }
    const helpText = defaultValue ? _i18n.i18n.translate('searchConnectors.configurationConnector.config.defaultValue', {
      defaultMessage: 'If left empty, the default value {defaultValue} will be used.',
      values: {
        defaultValue
      }
    }) : '';
    // toggle and sensitive textarea labels go next to the element, not in the row
    const rowLabel = display === _.DisplayType.TOGGLE || display === _.DisplayType.TEXTAREA && sensitive ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : tooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 17
      }
    }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      role: "tooltip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: tooltip,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 19
      }
    })))) : /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, label);
    if ((dependencies === null || dependencies === void 0 ? void 0 : dependencies.length) > 0) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: key,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        color: "subdued",
        borderRadius: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: rowLabel,
        helpText: helpText,
        error: validationErrors,
        isInvalid: !isValid,
        "data-test-subj": `entSearchContent-connector-configuration-formrow-${key}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_connector_configuration_field.ConnectorConfigurationField, {
        configEntry: configEntry,
        isLoading: isLoading,
        setConfigValue: value => {
          setConfigEntry(configEntry.key, value);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 19
        }
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: key,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: rowLabel,
      helpText: helpText,
      error: validationErrors,
      isInvalid: !isValid,
      "data-test-subj": `entSearchContent-connector-configuration-formrow-${key}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_connector_configuration_field.ConnectorConfigurationField, {
      configEntry: configEntry,
      isLoading: isLoading,
      setConfigValue: value => {
        setConfigEntry(configEntry.key, value);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 15
      }
    })));
  }));
};
exports.ConnectorConfigurationFormItems = ConnectorConfigurationFormItems;