"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedSearchObjectType = getSavedSearchObjectType;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _extract_tabs = require("../../common/service/extract_tabs");
var _search_migrations = require("./search_migrations");
var _constants = require("../../common/constants");
var _schema = require("./schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getSavedSearchObjectType(getSearchSourceMigrations) {
  return {
    name: 'search',
    indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
    hidden: false,
    namespaceType: 'multiple-isolated',
    convertToMultiNamespaceTypeVersion: '8.0.0',
    management: {
      icon: 'discoverApp',
      defaultSearchField: 'title',
      displayName: _constants.SavedSearchTypeDisplayName,
      importableAndExportable: true,
      getTitle(obj) {
        return obj.attributes.title;
      },
      getInAppUrl(obj) {
        return {
          path: `/app/discover#/view/${encodeURIComponent(obj.id)}`,
          uiCapabilitiesPath: 'discover_v2.show'
        };
      }
    },
    modelVersions: {
      1: {
        changes: [],
        schemas: {
          forwardCompatibility: _schema.SCHEMA_SEARCH_MODEL_VERSION_1.extends({}, {
            unknowns: 'ignore'
          }),
          create: _schema.SCHEMA_SEARCH_MODEL_VERSION_1
        }
      },
      2: {
        changes: [],
        schemas: {
          forwardCompatibility: _schema.SCHEMA_SEARCH_MODEL_VERSION_2.extends({}, {
            unknowns: 'ignore'
          }),
          create: _schema.SCHEMA_SEARCH_MODEL_VERSION_2
        }
      },
      3: {
        changes: [],
        schemas: {
          forwardCompatibility: _schema.SCHEMA_SEARCH_MODEL_VERSION_3.extends({}, {
            unknowns: 'ignore'
          }),
          create: _schema.SCHEMA_SEARCH_MODEL_VERSION_3
        }
      },
      4: {
        changes: [],
        schemas: {
          forwardCompatibility: _schema.SCHEMA_SEARCH_MODEL_VERSION_4.extends({}, {
            unknowns: 'ignore'
          }),
          create: _schema.SCHEMA_SEARCH_MODEL_VERSION_4
        }
      },
      5: {
        changes: [],
        schemas: {
          forwardCompatibility: _schema.SCHEMA_SEARCH_MODEL_VERSION_5.extends({}, {
            unknowns: 'ignore'
          }),
          create: _schema.SCHEMA_SEARCH_MODEL_VERSION_5
        }
      },
      6: {
        changes: [{
          type: 'data_backfill',
          backfillFn: _extract_tabs.extractTabsBackfillFn
        }],
        schemas: {
          forwardCompatibility: _schema.SCHEMA_SEARCH_MODEL_VERSION_6.extends({}, {
            unknowns: 'ignore'
          }),
          create: _schema.SCHEMA_SEARCH_MODEL_VERSION_6
        }
      },
      7: {
        changes: [],
        schemas: {
          forwardCompatibility: _schema.SCHEMA_SEARCH_MODEL_VERSION_7.extends({}, {
            unknowns: 'ignore'
          }),
          create: _schema.SCHEMA_SEARCH_MODEL_VERSION_7
        }
      },
      8: {
        changes: [],
        schemas: {
          forwardCompatibility: _schema.SCHEMA_SEARCH_MODEL_VERSION_8.extends({}, {
            unknowns: 'ignore'
          }),
          create: _schema.SCHEMA_SEARCH_MODEL_VERSION_8
        }
      },
      9: {
        changes: [],
        schemas: {
          forwardCompatibility: _schema.SCHEMA_SEARCH_MODEL_VERSION_9_SO_API_WORKAROUND.extends({}, {
            unknowns: 'ignore'
          }),
          create: _schema.SCHEMA_SEARCH_MODEL_VERSION_9_SO_API_WORKAROUND
        }
      }
    },
    mappings: {
      dynamic: false,
      properties: {
        title: {
          type: 'text'
        },
        description: {
          type: 'text'
        }
      }
    },
    schemas: {
      '8.8.0': _schema.SCHEMA_SEARCH_V8_8_0
    },
    migrations: () => (0, _search_migrations.getAllMigrations)(getSearchSourceMigrations())
  };
}