"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTagConnectionsUrl = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the url to use to redirect to the SavedObject management section with given tag
 * already selected in the query/filter bar.
 */
const getTagConnectionsUrl = (tag, basePath) => {
  const query = encodeURIComponent(`tag:("${tag.name}")`);
  return basePath.prepend(`/app/management/kibana/objects?initialQuery=${query}`);
};
exports.getTagConnectionsUrl = getTagConnectionsUrl;