"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STACK_RULE_TYPE_IDS_SUPPORTED_BY_OBSERVABILITY = exports.STACK_ALERTS_FEATURE_ID = exports.ML_ANOMALY_DETECTION_RULE_TYPE_ID = exports.ES_QUERY_ID = exports.DEGRADED_DOCS_RULE_TYPE_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const STACK_ALERTS_FEATURE_ID = exports.STACK_ALERTS_FEATURE_ID = 'stackAlerts';
const ES_QUERY_ID = exports.ES_QUERY_ID = '.es-query';
const ML_ANOMALY_DETECTION_RULE_TYPE_ID = exports.ML_ANOMALY_DETECTION_RULE_TYPE_ID = 'xpack.ml.anomaly_detection_alert';
const DEGRADED_DOCS_RULE_TYPE_ID = exports.DEGRADED_DOCS_RULE_TYPE_ID = 'datasetQuality.degradedDocs';

/**
 * These rule types are not the only stack rules. There are more.
 * The variable holds all stack rule types that support multiple
 * consumers aka the "Role visibility" UX dropdown.
 */
const STACK_RULE_TYPE_IDS_SUPPORTED_BY_OBSERVABILITY = exports.STACK_RULE_TYPE_IDS_SUPPORTED_BY_OBSERVABILITY = [ES_QUERY_ID, ML_ANOMALY_DETECTION_RULE_TYPE_ID, DEGRADED_DOCS_RULE_TYPE_ID];