"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.triggersActionsRoute = exports.ruleDetailsRoute = exports.getRuleDetailsRoute = exports.getEditRuleRoute = exports.getCreateRuleRoute = exports.editRuleRoute = exports.createRuleRoute = exports.createRuleFromTemplateRoute = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ruleDetailsRoute = exports.ruleDetailsRoute = '/rule/:ruleId';
const triggersActionsRoute = exports.triggersActionsRoute = '/app/management/insightsAndAlerting/triggersActions';
const createRuleRoute = exports.createRuleRoute = '/rules/create/:ruleTypeId';
const createRuleFromTemplateRoute = exports.createRuleFromTemplateRoute = '/rules/create/template/:templateId';
const editRuleRoute = exports.editRuleRoute = '/rules/edit/:id';
const getRuleDetailsRoute = ruleId => ruleDetailsRoute.replace(':ruleId', ruleId);
exports.getRuleDetailsRoute = getRuleDetailsRoute;
const getCreateRuleRoute = ruleTypeId => createRuleRoute.replace(':ruleTypeId', ruleTypeId);
exports.getCreateRuleRoute = getCreateRuleRoute;
const getEditRuleRoute = ruleId => editRuleRoute.replace(':id', ruleId);
exports.getEditRuleRoute = getEditRuleRoute;