"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processEnum = void 0;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** Identify special case output of schema.nullable() */
const isNullableOutput = schema => {
  var _schema$enum;
  return !(0, _common.isReferenceObject)(schema) && Object.keys(schema).length === 3 && ((_schema$enum = schema.enum) === null || _schema$enum === void 0 ? void 0 : _schema$enum.length) === 0 && schema.nullable === true && schema.type === undefined;
};

/**
 * Handle special case output of schema.nullable()
 *
 * We go from:
 * { anyOf: [ { type: 'string' }, { nullable: true, enum: [] } ] }
 *
 * To:
 * { type: 'string', nullable: true }
 */
const processNullableOutput = schema => {
  if (schema.anyOf.length !== 2) return false;
  const idx = schema.anyOf.findIndex(item => isNullableOutput(item));
  if (idx === -1) return false;
  const anyOf = schema.anyOf;
  delete schema.anyOf;
  schema.nullable = true;
  Object.assign(schema, anyOf[1 - idx]);
  return true;
};
const prettifyEnum = schema => {
  const result = [];
  let type;
  for (const item of schema.anyOf) {
    if ((0, _common.isReferenceObject)(item) || !item.enum || !item.type) return;
    if (type && type !== item.type) return;
    type = item.type;
    result.push(...item.enum);
  }
  schema.type = type;
  schema.enum = result;
  delete schema.anyOf;
};
const processEnum = schema => {
  if (!schema.anyOf) return;
  if (processNullableOutput(schema)) return;
  prettifyEnum(schema);
};
exports.processEnum = processEnum;