"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openApiVersion = exports.generateOpenApiDocument = void 0;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _oas_converter = require("./oas_converter");
var _process_router = require("./process_router");
var _process_versioned_router = require("./process_versioned_router");
var _util = require("./util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const openApiVersion = exports.openApiVersion = '3.0.0';
const generateOpenApiDocument = async (appRouters, opts) => {
  let {
    filters = {
      access: 'public'
    }
  } = opts;
  if (filters.access === 'public' && !filters.version) {
    filters = {
      ...filters,
      version: _coreHttpRouterServerInternal.BASE_PUBLIC_VERSION
    };
  }
  const converter = new _oas_converter.OasConverter();
  const paths = {};
  const getOpId = (0, _util.createOpIdGenerator)();
  const env = opts.env || {
    serverless: false
  };
  for (const router of appRouters.routers) {
    const result = await (0, _process_router.processRouter)({
      appRouter: router,
      converter,
      getOpId,
      filters,
      env
    });
    Object.assign(paths, result.paths);
  }
  for (const router of appRouters.versionedRouters) {
    const result = await (0, _process_versioned_router.processVersionedRouter)({
      appRouter: router,
      converter,
      getOpId,
      filters,
      env
    });
    Object.assign(paths, result.paths);
  }
  const tags = (0, _util.buildGlobalTags)(paths, opts.tags);
  return {
    openapi: openApiVersion,
    info: {
      title: opts.title,
      description: opts.description,
      version: opts.version
    },
    servers: [{
      url: opts.baseUrl
    }],
    paths,
    components: {
      ...converter.getSchemaComponents(),
      securitySchemes: {
        basicAuth: {
          type: 'http',
          scheme: 'basic'
        },
        apiKeyAuth: {
          type: 'apiKey',
          in: 'header',
          name: 'Authorization'
        }
      }
    },
    security: [{
      basicAuth: []
    }],
    tags,
    externalDocs: opts.docsUrl ? {
      url: opts.docsUrl
    } : undefined
  };
};
exports.generateOpenApiDocument = generateOpenApiDocument;