"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloneJob = exports.clearCloneJob = void 0;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cloneJob = jobToClone => dispatch => {
  dispatch({
    type: _action_types.CLONE_JOB_START,
    payload: jobToClone
  });
};
exports.cloneJob = cloneJob;
const clearCloneJob = () => dispatch => {
  dispatch({
    type: _action_types.CLONE_JOB_CLEAR
  });
};
exports.clearCloneJob = clearCloneJob;