"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldList = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/components/field_list/field_list.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FieldList = ({
  columns,
  fields,
  onRemoveField,
  addButton,
  emptyMessage,
  dataTestSubj
}) => {
  let message;
  if (!fields.length) {
    message = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: emptyMessage,
      titleSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 15
      }
    });
  }
  let extendedColumns;
  if (onRemoveField) {
    extendedColumns = columns.concat({
      name: 'Remove',
      width: '80px',
      actions: [{
        name: 'Remove',
        isPrimary: true,
        description: 'Remove this field',
        icon: 'trash',
        type: 'icon',
        color: 'danger',
        onClick: field => onRemoveField(field)
      }]
    });
  } else {
    extendedColumns = columns;
  }
  const search = {
    toolsRight: addButton ? addButton : undefined,
    box: {
      incremental: true,
      placeholder: 'Search'
    }
  };
  const pagination = {
    initialPageSize: 200,
    pageSizeOptions: [20, 100, 200]
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: fields,
    itemId: "name",
    columns: extendedColumns,
    search: search,
    pagination: pagination,
    sorting: true,
    message: message,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
};
exports.FieldList = FieldList;
FieldList.propTypes = {
  columns: _propTypes.default.array.isRequired,
  fields: _propTypes.default.array.isRequired,
  onRemoveField: _propTypes.default.func,
  addButton: _propTypes.default.node,
  emptyMessage: _propTypes.default.node,
  dataTestSubj: _propTypes.default.string
};