"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uptimeMonitorStatusRuleParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const uptimeMonitorStatusRuleParamsSchema = exports.uptimeMonitorStatusRuleParamsSchema = _configSchema.schema.object({
  stackVersion: _configSchema.schema.maybe(_configSchema.schema.string()),
  availability: _configSchema.schema.maybe(_configSchema.schema.object({
    range: _configSchema.schema.number(),
    rangeUnit: _configSchema.schema.string(),
    threshold: _configSchema.schema.string()
  })),
  // deprecated
  filters: _configSchema.schema.maybe(_configSchema.schema.oneOf([
  // deprecated
  _configSchema.schema.object({
    'monitor.type': _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    'observer.geo.name': _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    'url.port': _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }), _configSchema.schema.string()])),
  locations: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  numTimes: _configSchema.schema.number(),
  search: _configSchema.schema.maybe(_configSchema.schema.string()),
  shouldCheckStatus: _configSchema.schema.boolean(),
  shouldCheckAvailability: _configSchema.schema.boolean(),
  timerangeCount: _configSchema.schema.maybe(_configSchema.schema.number()),
  timerangeUnit: _configSchema.schema.maybe(_configSchema.schema.string()),
  // deprecated
  timerange: _configSchema.schema.maybe(_configSchema.schema.object({
    from: _configSchema.schema.string(),
    to: _configSchema.schema.string()
  })),
  version: _configSchema.schema.maybe(_configSchema.schema.number()),
  isAutoGenerated: _configSchema.schema.maybe(_configSchema.schema.boolean())
});