"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStorageDetailsPerIndex = getStorageDetailsPerIndex;
var _storage_explorer = require("../../../common/storage_explorer");
var _get_indices_stats = require("./get_indices_stats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getStorageDetailsPerIndex({
  client,
  indexLifecyclePhase
}) {
  const [indicesStats, indicesInfo, indicesLifecycleStatus] = await Promise.all([(0, _get_indices_stats.getIndicesStats)({
    client,
    indices: _get_indices_stats.stacktracesIndices
  }), (0, _get_indices_stats.getIndicesInfo)({
    client,
    indices: _get_indices_stats.stacktracesIndices
  }), (0, _get_indices_stats.getIndicesLifecycleStatus)({
    client,
    indices: _get_indices_stats.stacktracesIndices
  })]);
  const indices = indicesStats.indices || {};
  return Object.keys(indices).map(indexName => {
    var _stats$total$docs$cou, _stats$total, _stats$total$docs, _indexInfo$settings, _indexInfo$settings$i, _indexInfo$settings2, _indexInfo$settings2$, _stats$total$store$si, _stats$total2, _stats$total2$store;
    const stats = indices[indexName];
    const indexInfo = indicesInfo[indexName];
    const indexLifecycle = indicesLifecycleStatus[indexName];
    return {
      indexName,
      docCount: (_stats$total$docs$cou = (_stats$total = stats.total) === null || _stats$total === void 0 ? void 0 : (_stats$total$docs = _stats$total.docs) === null || _stats$total$docs === void 0 ? void 0 : _stats$total$docs.count) !== null && _stats$total$docs$cou !== void 0 ? _stats$total$docs$cou : 0,
      primaryShardsCount: (_indexInfo$settings = indexInfo.settings) === null || _indexInfo$settings === void 0 ? void 0 : (_indexInfo$settings$i = _indexInfo$settings.index) === null || _indexInfo$settings$i === void 0 ? void 0 : _indexInfo$settings$i.number_of_shards,
      replicaShardsCount: (_indexInfo$settings2 = indexInfo.settings) === null || _indexInfo$settings2 === void 0 ? void 0 : (_indexInfo$settings2$ = _indexInfo$settings2.index) === null || _indexInfo$settings2$ === void 0 ? void 0 : _indexInfo$settings2$.number_of_replicas,
      sizeInBytes: (_stats$total$store$si = (_stats$total2 = stats.total) === null || _stats$total2 === void 0 ? void 0 : (_stats$total2$store = _stats$total2.store) === null || _stats$total2$store === void 0 ? void 0 : _stats$total2$store.size_in_bytes) !== null && _stats$total$store$si !== void 0 ? _stats$total$store$si : 0,
      dataStream: indexInfo === null || indexInfo === void 0 ? void 0 : indexInfo.data_stream,
      lifecyclePhase: indexLifecycle && 'phase' in indexLifecycle ? indexLifecycle.phase : undefined
    };
  }).filter(item => {
    if (indexLifecyclePhase !== _storage_explorer.IndexLifecyclePhaseSelectOption.All && item.lifecyclePhase && item.lifecyclePhase !== indexLifecyclePhase) {
      return false;
    }
    return true;
  });
}