"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGroupedIndexLabel = getGroupedIndexLabel;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getGroupedIndexLabel(label) {
  switch (label) {
    case 'events':
      return _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.chart.samples', {
        defaultMessage: 'Samples'
      });
    case 'executables':
      return _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.chart.executables', {
        defaultMessage: 'Executables'
      });
    case 'metrics':
      return _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.chart.metrics', {
        defaultMessage: 'Metrics'
      });
    case 'stackframes':
      return _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.chart.stackframes', {
        defaultMessage: 'Stackframes'
      });
    case 'stacktraces':
      return _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.chart.stacktraces', {
        defaultMessage: 'Stacktraces'
      });
  }
}