"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNFunctionsGrid = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _profilingUtils = require("@kbn/profiling-utils");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_calculate_impact_estimates = require("../../hooks/use_calculate_impact_estimates");
var _cpu_label_with_hint = require("../cpu_label_with_hint");
var _frame_information_tooltip = require("../frame_information_window/frame_information_tooltip");
var _label_with_hint = require("../label_with_hint");
var _search_functions_input = require("../search_functions_input");
var _function_row = require("./function_row");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/topn_functions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TopNFunctionsGrid = ({
  topNFunctions,
  comparisonTopNFunctions,
  totalSeconds,
  showFullScreenSelector = true,
  isDifferentialView,
  baselineScaleFactor,
  comparisonScaleFactor,
  onFrameClick,
  onScroll,
  showDiffColumn = false,
  pageIndex,
  onChangePage,
  sortField,
  sortDirection,
  onChangeSort,
  dataTestSubj = 'topNFunctionsGrid',
  isEmbedded = false,
  searchFunctionName,
  onSearchFunctionNameChange
}) => {
  const [selectedRow, setSelectedRow] = (0, _react.useState)();
  const trackProfilingEvent = (0, _public.useUiTracker)({
    app: 'profiling'
  });
  const calculateImpactEstimates = (0, _use_calculate_impact_estimates.useCalculateImpactEstimate)();
  function onSort(newSortingColumns) {
    const lastItem = (0, _lodash.last)(newSortingColumns);
    if (lastItem) {
      onChangeSort(lastItem);
    }
  }
  const totalCount = (0, _react.useMemo)(() => (0, _utils.getTotalCount)(topNFunctions), [topNFunctions]);
  const rows = (0, _react.useMemo)(() => {
    return (0, _utils.getFunctionsRows)({
      baselineScaleFactor,
      comparisonScaleFactor,
      comparisonTopNFunctions,
      topNFunctions,
      totalSeconds,
      calculateImpactEstimates,
      functionNameSearchQuery: searchFunctionName
    });
  }, [baselineScaleFactor, calculateImpactEstimates, comparisonScaleFactor, comparisonTopNFunctions, searchFunctionName, topNFunctions, totalSeconds]);
  const sortedRows = (0, _react.useMemo)(() => {
    switch (sortField) {
      case _profilingUtils.TopNFunctionSortField.Frame:
        return (0, _lodash.orderBy)(rows, row => (0, _profilingUtils.getCalleeFunction)(row.frame), sortDirection);
      case _profilingUtils.TopNFunctionSortField.SelfCPU:
        return (0, _lodash.orderBy)(rows, row => row.selfCPUPerc, sortDirection);
      case _profilingUtils.TopNFunctionSortField.TotalCPU:
        return (0, _lodash.orderBy)(rows, row => row.totalCPUPerc, sortDirection);
      case _profilingUtils.TopNFunctionSortField.AnnualizedCo2:
        return (0, _lodash.orderBy)(rows, row => row.totalAnnualCO2kgs, sortDirection);
      case _profilingUtils.TopNFunctionSortField.AnnualizedDollarCost:
        return (0, _lodash.orderBy)(rows, row => row.totalAnnualCostUSD, sortDirection);
      default:
        return (0, _lodash.orderBy)(rows, sortField, sortDirection);
    }
  }, [rows, sortDirection, sortField]);
  const {
    columns,
    leadingControlColumns
  } = (0, _react.useMemo)(() => {
    const gridColumns = [{
      id: _profilingUtils.TopNFunctionSortField.Rank,
      schema: 'numeric',
      actions: {
        showHide: false
      },
      initialWidth: isDifferentialView ? 50 : 90,
      displayAsText: _i18n.i18n.translate('xpack.profiling.functionsView.rankColumnLabel', {
        defaultMessage: 'Rank'
      })
    }, {
      id: _profilingUtils.TopNFunctionSortField.Frame,
      actions: {
        showHide: false
      },
      displayAsText: _i18n.i18n.translate('xpack.profiling.functionsView.functionColumnLabel', {
        defaultMessage: 'Function'
      })
    }, {
      id: _profilingUtils.TopNFunctionSortField.Samples,
      initialWidth: isDifferentialView ? 100 : 200,
      schema: 'numeric',
      actions: {
        showHide: false
      },
      display: /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
        label: _i18n.i18n.translate('xpack.profiling.functionsView.samplesColumnLabel', {
          defaultMessage: 'Samples'
        }),
        hint: _i18n.i18n.translate('xpack.profiling.functionsView.samplesColumnLabel.hint', {
          defaultMessage: 'Estimated values'
        }),
        labelSize: "s",
        labelStyle: {
          fontWeight: 700
        },
        iconSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 11
        }
      })
    }, {
      id: _profilingUtils.TopNFunctionSortField.SelfCPU,
      schema: 'numeric',
      actions: {
        showHide: false
      },
      initialWidth: isDifferentialView ? 100 : 200,
      display: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
        type: "self",
        labelSize: "s",
        labelStyle: {
          fontWeight: 700
        },
        iconSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 11
        }
      })
    }, {
      id: _profilingUtils.TopNFunctionSortField.TotalCPU,
      schema: 'numeric',
      actions: {
        showHide: false
      },
      initialWidth: isDifferentialView ? 100 : 200,
      display: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
        type: "total",
        labelSize: "s",
        labelStyle: {
          fontWeight: 700
        },
        iconSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 11
        }
      })
    }];
    const gridLeadingControlColumns = [];
    if (showDiffColumn) {
      gridColumns.push({
        initialWidth: 60,
        id: _profilingUtils.TopNFunctionSortField.Diff,
        actions: {
          showHide: false
        },
        displayAsText: _i18n.i18n.translate('xpack.profiling.functionsView.diffColumnLabel', {
          defaultMessage: 'Diff'
        })
      });
    }
    if (!isDifferentialView) {
      gridColumns.push({
        id: _profilingUtils.TopNFunctionSortField.AnnualizedCo2,
        actions: {
          showHide: false
        },
        initialWidth: isDifferentialView ? 100 : 200,
        schema: 'numeric',
        display: /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
          label: _i18n.i18n.translate('xpack.profiling.functionsView.annualizedCo2', {
            defaultMessage: 'Annualized CO2'
          }),
          hint: _i18n.i18n.translate('xpack.profiling.functionsView.annualizedCo2.hint', {
            defaultMessage: 'Indicates the CO2 emission of the function and any functions called by it.'
          }),
          labelSize: "s",
          labelStyle: {
            fontWeight: 700
          },
          iconSize: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 217,
            columnNumber: 13
          }
        })
      }, {
        id: _profilingUtils.TopNFunctionSortField.AnnualizedDollarCost,
        schema: 'numeric',
        actions: {
          showHide: false
        },
        initialWidth: isDifferentialView ? 100 : 200,
        display: /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
          label: _i18n.i18n.translate('xpack.profiling.functionsView.annualizedDollarCost', {
            defaultMessage: `Annualized dollar cost`
          }),
          hint: _i18n.i18n.translate('xpack.profiling.functionsView.annualizedDollarCost.hint', {
            defaultMessage: `Indicates the Dollar cost of the function and any functions called by it.`
          }),
          labelSize: "s",
          labelStyle: {
            fontWeight: 700
          },
          iconSize: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 237,
            columnNumber: 13
          }
        })
      });
      gridLeadingControlColumns.push({
        id: 'actions',
        width: 40,
        headerCellRender() {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 257,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("span", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 258,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('xpack.profiling.topNFunctionsGrid.span.controlsLabel', {
            defaultMessage: 'Controls'
          })));
        },
        rowCellRender: function RowCellRender({
          rowIndex
        }) {
          function handleOnClick() {
            trackProfilingEvent({
              metric: 'topN_function_details_click'
            });
            setSelectedRow(sortedRows[rowIndex]);
          }
          return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            "data-test-subj": "profilingTopNFunctionsGridButton",
            "aria-label": _i18n.i18n.translate('xpack.profiling.topNFunctionsGrid.euiButtonIcon.showActionsLabel', {
              defaultMessage: 'Show actions'
            }),
            iconType: "expand",
            color: "text",
            onClick: handleOnClick,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 272,
              columnNumber: 13
            }
          });
        }
      });
    }
    return {
      columns: gridColumns,
      leadingControlColumns: gridLeadingControlColumns
    };
  }, [isDifferentialView, sortedRows, showDiffColumn, trackProfilingEvent]);
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)(columns.map(({
    id
  }) => id));
  function RenderCellValue({
    rowIndex,
    columnId,
    setCellProps
  }) {
    const data = sortedRows[rowIndex];
    if (data) {
      return /*#__PURE__*/_react.default.createElement(_function_row.FunctionRow, {
        functionRow: data,
        columnId: columnId,
        totalCount: totalCount,
        onFrameClick: onFrameClick,
        setCellProps: setCellProps,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 295,
          columnNumber: 9
        }
      });
    }
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_search_functions_input.SearchFunctionsInput, {
    onChange: onSearchFunctionNameChange,
    value: searchFunctionName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "data-test-subj": dataTestSubj,
    "aria-label": _i18n.i18n.translate('xpack.profiling.topNFunctionsGrid.euiDataGrid.topNFunctionsLabel', {
      defaultMessage: 'TopN functions'
    }),
    columns: columns,
    columnVisibility: {
      visibleColumns,
      setVisibleColumns
    },
    rowCount: sortedRows.length,
    renderCellValue: RenderCellValue,
    sorting: {
      columns: [{
        id: sortField,
        direction: sortDirection
      }],
      onSort
    },
    leadingControlColumns: leadingControlColumns,
    pagination: {
      pageIndex,
      pageSize: 100,
      // Left it empty on purpose as it is a required property on the pagination
      onChangeItemsPerPage: () => {},
      onChangePage,
      pageSizeOptions: []
    },
    rowHeightsOptions: {
      defaultHeight: 'auto'
    },
    toolbarVisibility: {
      showColumnSelector: false,
      showKeyboardShortcuts: !isDifferentialView,
      showDisplaySelector: !isDifferentialView,
      showFullScreenSelector: showFullScreenSelector && !isDifferentialView,
      showSortSelector: false
    },
    virtualizationOptions: {
      onScroll
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 9
    }
  }), selectedRow && /*#__PURE__*/_react.default.createElement(_frame_information_tooltip.FrameInformationTooltip, {
    compressed: true,
    onClose: () => {
      setSelectedRow(undefined);
    },
    frame: (0, _utils.convertRowToFrame)(selectedRow),
    totalSeconds: totalSeconds,
    totalSamples: totalCount,
    showSymbolsStatus: !isEmbedded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 11
    }
  })));
};
exports.TopNFunctionsGrid = TopNFunctionsGrid;