"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePresentationPanelHeaderActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _kibana_services = require("../../kibana_services");
var _panel_actions = require("../../panel_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/presentation_panel/public/panel_component/panel_header/use_presentation_panel_header_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const disabledNotifications = ['ACTION_FILTERS_NOTIFICATION'];
const usePresentationPanelHeaderActions = (showNotifications, showBadges, api, getActions) => {
  const [badges, setBadges] = (0, _react.useState)([]);
  const [notifications, setNotifications] = (0, _react.useState)([]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();

  /**
   * Get all actions once on mount of the panel. Any actions that are Frequent Compatibility
   * Change Actions need to be subscribed to so they can change over the lifetime of this panel.
   */
  (0, _react.useEffect)(() => {
    let canceled = false;
    const subscriptions = new _rxjs.Subscription();
    const getTriggerCompatibleActions = getActions !== null && getActions !== void 0 ? getActions : _kibana_services.uiActions.getTriggerCompatibleActions;
    const getActionsForTrigger = async triggerId => {
      var _ref, _api$disabledActionId, _api$disabledActionId2;
      let nextActions = (_ref = await getTriggerCompatibleActions(triggerId, {
        embeddable: api
      })) !== null && _ref !== void 0 ? _ref : [];
      const disabledActions = ((_api$disabledActionId = (_api$disabledActionId2 = api.disabledActionIds$) === null || _api$disabledActionId2 === void 0 ? void 0 : _api$disabledActionId2.value) !== null && _api$disabledActionId !== void 0 ? _api$disabledActionId : []).concat(disabledNotifications);
      nextActions = nextActions.filter(badge => disabledActions.indexOf(badge.id) === -1);
      return nextActions;
    };
    const handleActionCompatibilityChange = (type, isCompatible, action) => {
      if (canceled) return;
      (type === 'badge' ? setBadges : setNotifications)(currentActions => {
        const newActions = currentActions === null || currentActions === void 0 ? void 0 : currentActions.filter(current => current.id !== action.id);
        if (isCompatible) return [...newActions, action];
        return newActions;
      });
    };
    (async () => {
      const [initialBadges, initialNotifications] = await Promise.all([getActionsForTrigger(_panel_actions.PANEL_BADGE_TRIGGER), getActionsForTrigger(_panel_actions.PANEL_NOTIFICATION_TRIGGER)]);
      if (canceled) return;
      setBadges(initialBadges);
      setNotifications(initialNotifications);
      const apiContext = {
        embeddable: api
      };

      // subscribe to any frequently changing badge actions
      const frequentlyChangingBadges = await _kibana_services.uiActions.getFrequentlyChangingActionsForTrigger(_panel_actions.PANEL_BADGE_TRIGGER, apiContext);
      if (canceled) return;
      for (const badge of frequentlyChangingBadges) {
        var _badge$getCompatibili;
        const compatibilitySubject = (_badge$getCompatibili = badge.getCompatibilityChangesSubject(apiContext)) === null || _badge$getCompatibili === void 0 ? void 0 : _badge$getCompatibili.pipe((0, _rxjs.switchMap)(async () => {
          return await badge.isCompatible({
            ...apiContext,
            trigger: _panel_actions.panelBadgeTrigger
          });
        })).subscribe(async isCompatible => {
          handleActionCompatibilityChange('badge', isCompatible, badge);
        });
        subscriptions.add(compatibilitySubject);
      }

      // subscribe to any frequently changing notification actions
      const frequentlyChangingNotifications = await _kibana_services.uiActions.getFrequentlyChangingActionsForTrigger(_panel_actions.PANEL_NOTIFICATION_TRIGGER, apiContext);
      if (canceled) return;
      for (const notification of frequentlyChangingNotifications) {
        if (!disabledNotifications.includes(notification.id)) {
          var _notification$getComp;
          const compatibilitySubject = (_notification$getComp = notification.getCompatibilityChangesSubject(apiContext)) === null || _notification$getComp === void 0 ? void 0 : _notification$getComp.pipe((0, _rxjs.switchMap)(async () => {
            return await notification.isCompatible({
              ...apiContext,
              trigger: _panel_actions.panelNotificationTrigger
            });
          })).subscribe(async isCompatible => {
            handleActionCompatibilityChange('notification', isCompatible, notification);
          });
          subscriptions.add(compatibilitySubject);
        }
      }
    })();
    return () => {
      canceled = true;
      subscriptions.unsubscribe();
    };
    // Disable exhaustive deps because this is meant to be run once on mount.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const badgeElements = (0, _react.useMemo)(() => {
    if (!showBadges) return [];
    return badges === null || badges === void 0 ? void 0 : badges.map(badge => {
      var _badge$getDisplayName;
      const tooltipText = (_badge$getDisplayName = badge.getDisplayNameTooltip) === null || _badge$getDisplayName === void 0 ? void 0 : _badge$getDisplayName.call(badge, {
        embeddable: api,
        trigger: _panel_actions.panelBadgeTrigger
      });
      const badgeElement = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        key: badge.id,
        iconType: badge.getIconType({
          embeddable: api,
          trigger: _panel_actions.panelBadgeTrigger
        }),
        onClick: () => badge.execute({
          embeddable: api,
          trigger: _panel_actions.panelBadgeTrigger
        }),
        onClickAriaLabel: badge.getDisplayName({
          embeddable: api,
          trigger: _panel_actions.panelBadgeTrigger
        }),
        "data-test-subj": `embeddablePanelBadge-${badge.id}`
      }, tooltipText ? {
        'aria-label': tooltipText
      } : {}, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 9
        }
      }), badge.MenuItem ? /*#__PURE__*/_react.default.createElement(badge.MenuItem, {
        context: {
          embeddable: api,
          trigger: _panel_actions.panelBadgeTrigger
        }
      }) : badge.getDisplayName({
        embeddable: api,
        trigger: _panel_actions.panelBadgeTrigger
      }));
      return tooltipText ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        key: badge.id,
        content: tooltipText,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 9
        }
      }, badgeElement) : badgeElement;
    });
  }, [api, badges, showBadges]);
  const notificationElements = (0, _react.useMemo)(() => {
    if (!showNotifications) return [];
    return notifications === null || notifications === void 0 ? void 0 : notifications.map(notification => {
      let notificationComponent = notification.MenuItem ? (/*#__PURE__*/_react.default.createElement(notification.MenuItem, {
        key: notification.id,
        context: {
          embeddable: api,
          trigger: _panel_actions.panelNotificationTrigger
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        "data-test-subj": `embeddablePanelNotification-${notification.id}`,
        key: notification.id,
        css: {
          marginTop: euiTheme.size.xs,
          marginRight: euiTheme.size.xs
        },
        onClick: () => notification.execute({
          embeddable: api,
          trigger: _panel_actions.panelNotificationTrigger
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 9
        }
      }, notification.getDisplayName({
        embeddable: api,
        trigger: _panel_actions.panelNotificationTrigger
      }));
      if (notification.getDisplayNameTooltip) {
        const tooltip = notification.getDisplayNameTooltip({
          embeddable: api,
          trigger: _panel_actions.panelNotificationTrigger
        });
        if (tooltip) {
          notificationComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            position: "top",
            delay: "regular",
            content: tooltip,
            key: notification.id,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 213,
              columnNumber: 13
            }
          }, notificationComponent);
        }
      }
      return notificationComponent;
    });
  }, [api, euiTheme.size.xs, notifications, showNotifications]);
  return {
    badgeElements,
    notificationElements
  };
};
exports.usePresentationPanelHeaderActions = usePresentationPanelHeaderActions;