"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSortedEntries = createSortedEntries;
exports.sortObjectByKeys = sortObjectByKeys;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Simple utilities for deterministic field ordering.
 */

/**
 * Sort object keys alphabetically for deterministic ordering.
 */
function sortObjectByKeys(obj) {
  return Object.keys(obj).sort().reduce((sorted, key) => {
    sorted[key] = obj[key];
    return sorted;
  }, {});
}

/**
 * Create sorted key-value entries from an object.
 */
function createSortedEntries(obj) {
  return Object.keys(obj).sort().map(key => [key, obj[key]]);
}