"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSavedQueryRoute = void 0;
var _lodash = require("lodash");
var _spacesUtils = require("@kbn/spaces-utils");
var _get_internal_saved_object_client = require("../../utils/get_internal_saved_object_client");
var _route_validation = require("../../utils/build_validation/route_validation");
var _constants = require("../../../common/constants");
var _utils = require("./utils");
var _common = require("../../../common");
var _types = require("../../../common/types");
var _utils2 = require("../utils");
var _update_saved_query_route = require("../../../common/api/saved_query/update_saved_query_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateSavedQueryRoute = (router, osqueryContext) => {
  router.versioned.put({
    access: 'public',
    path: '/api/osquery/saved_queries/{id}',
    security: {
      authz: {
        requiredPrivileges: [`${_common.PLUGIN_ID}-writeSavedQueries`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: (0, _route_validation.buildRouteValidation)(_update_saved_query_route.updateSavedQueryRequestParamsSchema),
        body: (0, _route_validation.buildRouteValidation)(_update_saved_query_route.updateSavedQueryRequestBodySchema)
      }
    }
  }, async (context, request, response) => {
    var _space$id, _coreContext$security, _osqueryContext$servi;
    const coreContext = await context.core;
    const spaceScopedClient = await (0, _get_internal_saved_object_client.createInternalSavedObjectsClientForSpaceId)(osqueryContext, request);
    const space = await osqueryContext.service.getActiveSpace(request);
    const spaceId = (_space$id = space === null || space === void 0 ? void 0 : space.id) !== null && _space$id !== void 0 ? _space$id : _spacesUtils.DEFAULT_SPACE_ID;
    const currentUser = (_coreContext$security = coreContext.security.authc.getCurrentUser()) === null || _coreContext$security === void 0 ? void 0 : _coreContext$security.username;
    const {
      id,
      description,
      platform,
      query,
      version,
      interval,
      timeout,
      snapshot,
      removed,
      // eslint-disable-next-line @typescript-eslint/naming-convention
      ecs_mapping
    } = request.body;
    const isPrebuilt = await (0, _utils.isSavedQueryPrebuilt)((_osqueryContext$servi = osqueryContext.service.getPackageService()) === null || _osqueryContext$servi === void 0 ? void 0 : _osqueryContext$servi.asInternalUser, request.params.id, spaceScopedClient, spaceId);
    if (isPrebuilt) {
      return response.conflict({
        body: `Elastic prebuilt Saved query cannot be updated.`
      });
    }
    const conflictingEntries = await spaceScopedClient.find({
      type: _types.savedQuerySavedObjectType,
      filter: `${_types.savedQuerySavedObjectType}.attributes.id: "${id}"`
    });
    if ((0, _lodash.some)((0, _lodash.filter)(conflictingEntries.saved_objects, soObject => soObject.id !== request.params.id), ['attributes.id', id])) {
      return response.conflict({
        body: `Saved query with id "${id}" already exists.`
      });
    }
    const updatedSavedQuerySO = await spaceScopedClient.update(_types.savedQuerySavedObjectType, request.params.id, {
      id,
      description: description || '',
      platform,
      query,
      version,
      interval,
      timeout,
      snapshot,
      removed,
      ecs_mapping: (0, _utils2.convertECSMappingToArray)(ecs_mapping),
      updated_by: currentUser,
      updated_at: new Date().toISOString()
    }, {
      refresh: 'wait_for'
    });
    if (ecs_mapping || updatedSavedQuerySO.attributes.ecs_mapping) {
      // @ts-expect-error update types
      updatedSavedQuerySO.attributes.ecs_mapping = ecs_mapping || updatedSavedQuerySO.attributes.ecs_mapping &&
      // @ts-expect-error update types
      (0, _utils2.convertECSMappingToObject)(updatedSavedQuerySO.attributes.ecs_mapping) || {};
    }
    const {
      attributes
    } = updatedSavedQuerySO;
    const data = {
      description: attributes.description,
      id: attributes.id,
      removed: attributes.removed,
      snapshot: attributes.snapshot,
      version: attributes.version,
      ecs_mapping: attributes.ecs_mapping,
      interval: attributes.interval,
      timeout: attributes.timeout,
      platform: attributes.platform,
      query: attributes.query,
      updated_at: attributes.updated_at,
      updated_by: attributes.updated_by,
      saved_object_id: updatedSavedQuerySO.id
    };
    return response.ok({
      body: {
        data
      }
    });
  });
};
exports.updateSavedQueryRoute = updateSavedQueryRoute;