"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findLiveQueryRoute = void 0;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _common = require("@kbn/spaces-plugin/common");
var _route_validation = require("../../utils/build_validation/route_validation");
var _constants = require("../../../common/constants");
var _common2 = require("../../../common");
var _search_strategy = require("../../../common/search_strategy");
var _api = require("../../../common/api");
var _build_query = require("../../../common/utils/build_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findLiveQueryRoute = (router, osqueryContext) => {
  router.versioned.get({
    access: 'public',
    path: '/api/osquery/live_queries',
    security: {
      authz: {
        requiredPrivileges: [`${_common2.PLUGIN_ID}-read`]
      }
    },
    options: {
      tags: ['api']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _route_validation.buildRouteValidation)(_api.findLiveQueryRequestQuerySchema)
      }
    }
  }, async (context, request, response) => {
    const abortSignal = getRequestAbortedSignal(request.events.aborted$);
    try {
      var _osqueryContext$servi, _await$osqueryContext, _request$query$page, _request$query$pageSi, _request$query$sortOr, _request$query$sort;
      const spaceId = osqueryContext !== null && osqueryContext !== void 0 && (_osqueryContext$servi = osqueryContext.service) !== null && _osqueryContext$servi !== void 0 && _osqueryContext$servi.getActiveSpace ? ((_await$osqueryContext = await osqueryContext.service.getActiveSpace(request)) === null || _await$osqueryContext === void 0 ? void 0 : _await$osqueryContext.id) || _common.DEFAULT_SPACE_ID : _common.DEFAULT_SPACE_ID;
      const search = await context.search;
      const res = await (0, _rxjs.lastValueFrom)(search.search({
        factoryQueryType: _search_strategy.OsqueryQueries.actions,
        kuery: request.query.kuery,
        pagination: (0, _build_query.generateTablePaginationOptions)((_request$query$page = request.query.page) !== null && _request$query$page !== void 0 ? _request$query$page : 0, (_request$query$pageSi = request.query.pageSize) !== null && _request$query$pageSi !== void 0 ? _request$query$pageSi : 100),
        sort: {
          direction: (_request$query$sortOr = request.query.sortOrder) !== null && _request$query$sortOr !== void 0 ? _request$query$sortOr : 'desc',
          field: (_request$query$sort = request.query.sort) !== null && _request$query$sort !== void 0 ? _request$query$sort : 'created_at'
        },
        spaceId
      }, {
        abortSignal,
        strategy: 'osquerySearchStrategy'
      }));
      return response.ok({
        body: {
          data: {
            ...(0, _lodash.omit)(res, 'edges'),
            items: res.edges
          }
        }
      });
    } catch (e) {
      var _e$statusCode;
      return response.customError({
        statusCode: (_e$statusCode = e.statusCode) !== null && _e$statusCode !== void 0 ? _e$statusCode : 500,
        body: {
          message: e.message
        }
      });
    }
  });
};
exports.findLiveQueryRoute = findLiveQueryRoute;
function getRequestAbortedSignal(aborted$) {
  const controller = new AbortController();
  aborted$.subscribe(() => controller.abort());
  return controller.signal;
}